IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cbtes_Ctas_Contables_Generar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cbtes_Ctas_Contables_Generar] 
END
GO


CREATE PROCEDURE [dbo].[CP_Cbtes_Ctas_Contables_Generar] 

@pId_Trans		INT, 
@pFlagRegenerar TINYINT
AS
SET NOCOUNT ON


IF EXISTS (SELECT 1 FROM sys.objects WHERE name = 'CP_Cbtes_Ctas_Contables_Generar_' AND type = 'P')
BEGIN
		EXEC CP_Cbtes_Ctas_Contables_Generar_ @pId_Trans,@pFlagRegenerar
		RETURN
END



/*Declaracion de Variables*/
DECLARE @Flag_Compromete_Asientos	SMALLINT
DECLARE @Flag_Compromete_Factura	SMALLINT
DECLARE @Flag_Compromete_Trans_Fondos SMALLINT
DECLARE @Flag_Compromete_Recibos	SMALLINT
DECLARE @Fecha_Cbte					DATETIME
DECLARE @Id_Cliente					INT
DECLARE @Id_Tipo_Cbte				CHAR(4)
DECLARE @Id_Cta_Contable			INT
DECLARE @Alias						INT
DECLARE @Id_Asiento					INT
DECLARE @Id_Centro_Costo			CHAR(10)
DECLARE @Id_Ejercicio_Corresp		INT
DECLARE @Id_Plan_Cta_Corresp		INT
DECLARE @Imp_Total_Cbte				DECIMAL(12,2)
DECLARE @Debe						DECIMAL(12,2)
DECLARE @Haber						DECIMAL(12,2)
DECLARE @Id_Producto				VARCHAR(14)
DECLARE @Id_Tipo_Reten				VARCHAR(10)
DECLARE @NroItem					SMALLINT
DECLARE @CMC_UltItem				SMALLINT
DECLARE @CMC_UltId_Periodo_Caja		INT
DECLARE @CMC_Id_Concepto			INT
DECLARE @VAL_UltId_Valor			INT
DECLARE @VAL_UltId_Periodo_Caja		INT
DECLARE @VAL_Id_Tipo_Val			CHAR(3)
DECLARE @Id_Cond_Pago				SMALLINT
DECLARE @VAL_Id_Periodo_Caja		INT
DECLARE @CP_Id_Caja					INT
DECLARE @ID_TARJETA                 VARCHAR(10)
DECLARE @ID_CTA_BANCO               SMALLINT
DECLARE @ID_TRANS_ORIGEN            INT
DECLARE @Mensaje					VARCHAR(100)
/*FIN Declaracion de Variables*/

--PRINT 'Procedimiento: CP_Cbtes_Ctas_Contables_Generar Trans: '+ CAST(@pId_Trans AS VARCHAR(10))

IF(@pId_Trans = 0)
BEGIN
	RETURN 999
END

BEGIN TRY
	BEGIN TRAN

	IF(@pFlagRegenerar = 1)
	BEGIN
		DELETE FROM Cbtes_Ctas_Contables WHERE Id_Trans = @pId_Trans
	END

	/*************************************************************************************************/

	SET @Id_Tipo_Cbte				= (SELECT Id_Tipo_Cbte FROM Cbtes WHERE Id_Trans = @pId_Trans)

	SELECT  @Flag_Compromete_Asientos		= ISNULL(Compromete_Asientos, 0),
			@Flag_Compromete_Factura		= ISNULL(Compromete_Factura, 0),
			@Flag_Compromete_Trans_Fondos	= ISNULL(Compromete_Trans_Fondos, 0),
			@Flag_Compromete_Recibos		= ISNULL(Compromete_Recibos, 0)
	FROM Cbtes_Tipos
	WHERE 
	Id_Tipo_Cbte = @Id_Tipo_Cbte

	/*************************************************************************************************/

	IF(@Flag_Compromete_Asientos = 0)
	BEGIN
		COMMIT
		SET @Mensaje = 'El Cbte. no Genera Asiento'

		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage
				,@pId_Trans		AS Id_Trans		
			
		RETURN 0
	END

	/*************************************************************************************************/

	SELECT  @Id_Cliente		= ISNULL(Id_Cliente, 0),
			@Fecha_Cbte		= ISNULL(Fecha, '19000101'),
			@Imp_Total_Cbte	= ISNULL(Imp_Total, 0)
	FROM Cbtes
	WHERE 
	Id_Trans = @pId_Trans

	/*************************************************************************************************/

	SET @Id_Ejercicio_Corresp = (SELECT Id_Ejercicio FROM Plan_Ctas_Ejercicios WHERE Fecha_Inicio <= @Fecha_Cbte AND DATEADD(dd, 1, Fecha_Cierre) > @Fecha_Cbte)
	SET @Id_Plan_Cta_Corresp = (SELECT Id_Plan_Cta FROM Plan_Ctas WHERE Id_Ejercicio = @Id_Ejercicio_Corresp)
	----PRINT 'Nro. de Ejercicio: ' + CONVERT(VARCHAR(10), @Id_Ejercicio_Corresp) + '. Nro. Plan de Cuenta: ' + CONVERT(VARCHAR(10), @Id_Plan_Cta_Corresp)

	IF(@Flag_Compromete_Factura = 1)
	BEGIN
		----PRINT 'Compromete Factura'
	
		SET @Id_Cond_Pago = (SELECT Id_Cond_Pago FROM Cbtes WHERE Id_Trans = @pId_Trans)
	
		IF(@Id_Cond_Pago NOT IN (1)) /*Si no es contado*/
		BEGIN
			----PRINT 'Cond. Pago NO ES CONTADO. @Id_Cond_Pago: ' + CONVERT(VARCHAR(10), @Id_Cond_Pago)
		
			/*Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
			----PRINT 'Generacion Cuenta Contable: DEBE'
			SET @Alias = (SELECT Id_Alias_Cta_Cont_Venta FROM Clientes WHERE Id_Cliente = @Id_Cliente)
			SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = (SELECT Id_Centro_Costo FROM Clientes WHERE Id_Cliente = @Id_Cliente)
			SET @Debe = @Imp_Total_Cbte
			SET @NroItem = 1
			----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe,			0/*Haber*/,			''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)
			/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago NO es Contado)*/
		END
		ELSE
		BEGIN
			----PRINT 'Cond. Pago ES CONTADO'
		
			/*Insert: Cuenta Contable: DEBE (SI la Cond. Pago ES Contado)*/
			----PRINT 'Generacion Cuenta Contable: DEBE'
			SET @VAL_Id_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE Id_Trans = @pId_Trans), 0)		
			SET @CP_Id_Caja = ISNULL((SELECT Id_Caja FROM Cajas_Periodos WHERE Id_Periodo_Caja = @VAL_Id_Periodo_Caja), 0)		
			SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Cajas WHERE Id_Caja = @CP_Id_Caja), 0)
			SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Alias = @Alias AND Id_Plan_Cta = @Id_Plan_Cta_Corresp)
			SET @Id_Centro_Costo = ISNULL((SELECT Id_Cta_Contable FROM Cajas WHERE Id_Caja = @CP_Id_Caja), '')
			SET @Debe = @Imp_Total_Cbte
			SET @NroItem = 1
			----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
		
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			@Debe,			0/*Haber*/,			''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)
			/*FIN Insert: Cuenta Contable: DEBE (SI la Cond. Pago ES Contado)*/
		END
	
		/*Insert: Cuenta Contable: HABER*/
		----PRINT 'Generacion Cuenta Contable: HABER'
	
		--PRINT 'Generacion de Items de Productos'
		DECLARE curGenCtaCteHaber CURSOR FOR 
			SELECT DISTINCT Id_Producto FROM Cbtes_Items WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaber
		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Alias_Cta_Cont FROM Productos WHERE Id_Producto = @Id_Producto)
			SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = (SELECT Id_Centro_Costo FROM Productos WHERE Id_Producto = @Id_Producto)
			SET @Haber = (SELECT SUM(Imp_Gravado) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto = @Id_Producto)
			SET @NroItem = @NroItem + 1
		
			----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Producto: ' + @Id_Producto + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaber INTO @Id_Producto
		END 
		CLOSE curGenCtaCteHaber;
		DEALLOCATE curGenCtaCteHaber;
		/*FIN Insert: Cuenta Contable: HABER*/
	
		----PRINT 'Generacion de Items de Percepciones'	
		DECLARE curGenCtaCteHaberPercep CURSOR FOR 
			SELECT DISTINCT Id_Tipo_Reten	FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans

		OPEN curGenCtaCteHaberPercep
		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		WHILE @@FETCH_STATUS = 0
		BEGIN

			SET @Alias = (SELECT Id_Cta_Contable FROM Cbtes_Reten_Tipos WHERE Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
			SET @Id_Centro_Costo = ''
			SET @Haber = (SELECT SUM(Importe) FROM Cbtes_Reten WHERE Id_Trans = @pId_Trans AND Id_Tipo_Reten = @Id_Tipo_Reten)
			SET @NroItem = @NroItem + 1
		
			----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Tipo_Reten: ' + @Id_Tipo_Reten + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)

		FETCH NEXT FROM curGenCtaCteHaberPercep INTO @Id_Tipo_Reten
		END 
		CLOSE curGenCtaCteHaberPercep;
		DEALLOCATE curGenCtaCteHaberPercep;
	
		----PRINT 'Generacion de Items de Iva'
		SET @Alias = (SELECT ISNULL(Valor_Integer,0) FROM xParametros WHERE IdParametro = 'Iva_Debito_Fiscal')
		SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
		SET @Id_Centro_Costo = ''
		SET @Haber = (SELECT SUM(Imp_Iva) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans AND Id_Producto IN (SELECT Id_Producto FROM Productos WHERE Id_Iva IN (SELECT Id_Iva FROM Productos_TasaIva WHERE (Porc1 <> 0 OR Porc1 IS NOT NULL))))
	
		IF(@Haber <> 0)
		BEGIN
			SET @NroItem = @NroItem + 1
		
			----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable) + '. Centro_Costo: ' + CONVERT(VARCHAR(10), @Id_Centro_Costo) 
	
			INSERT INTO Cbtes_Ctas_Contables
			(Id_Trans,		Id_Cta_Contable,	Fecha,
			Debe,			Haber,				Observacion,
			Alias,			Id_Asiento,			Id_Centro_Costo,
			Item)
			VALUES									
			(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
			0/*Debe*/,		@Haber,				''/*Observacion*/,
			@Alias,			0/*El proceso de A.R. lo carga*/,@Id_Centro_Costo,
			@NroItem)		
		END
	
		----PRINT 'FIN Compromete Factura'
	END /*IF(@Flag_Compromete_Factura = 1)*/


	IF(@Flag_Compromete_Trans_Fondos = 1)
	BEGIN
		----PRINT 'Compromete Transferencia de Fondos'
	
		/*Insert: Cuenta Contable: DEBE*/
		----PRINT 'Generacion Cuenta Contable: DEBE'
		SET @CMC_UltItem = ISNULL((SELECT MAX(Item) FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans), 0)
		----PRINT 'Cajas_Mov_Conceptos. Ult. Item Generado: ' + CONVERT(VARCHAR(10), @CMC_UltItem)
	
		IF(@CMC_UltItem <> 0)
		BEGIN
			SET @CMC_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans AND Item = @CMC_UltItem), 0)
		
			----PRINT 'Generacion de Items por cada concepto del Periodo de Caja: ' + CONVERT(VARCHAR(10), @CMC_UltId_Periodo_Caja)
			DECLARE curGenCtaCteDebe_CMC CURSOR FOR 
				SELECT DISTINCT Id_Concepto FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans
								AND Id_Periodo_Caja = @CMC_UltId_Periodo_Caja
		
			SET @NroItem = 0
		
			OPEN curGenCtaCteDebe_CMC
			FETCH NEXT FROM curGenCtaCteDebe_CMC INTO @CMC_Id_Concepto
			WHILE @@FETCH_STATUS = 0
			BEGIN

				SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Conceptos WHERE Id_Concepto = @CMC_Id_Concepto),0)
				SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)	
				SET @Haber = (SELECT ISNULL(SUM(Importe), 0) FROM Cajas_Mov_Conceptos WHERE Id_Trans = @pId_Trans AND Id_Concepto = @CMC_Id_Concepto AND Id_Periodo_Caja = @CMC_UltId_Periodo_Caja)
				SET @NroItem = @NroItem + 1
		
				----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Concepto: ' + CONVERT(VARCHAR(10), @CMC_Id_Concepto) + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				@Debe,			0/*Haber*/,			''/*Observacion*/,
				@Alias,			0/*Id_Asiento*/,	''/*Id_Centro_Costo*/,
				@NroItem)

				FETCH NEXT FROM curGenCtaCteDebe_CMC INTO @CMC_Id_Concepto
			END 
			CLOSE curGenCtaCteDebe_CMC;
			DEALLOCATE curGenCtaCteDebe_CMC;
		END /*IF(@CMC_UltItem <> 0)*/
	
		/*Insert: Cuenta Contable: HABER*/
		----PRINT 'Generacion Cuenta Contable: HABER'
		SET @VAL_UltId_Valor = ISNULL((SELECT MAX(Id_Valor) FROM Valores WHERE Id_Trans = @pId_Trans), 0)
		----PRINT 'Valores. Ult. Id_Valor Generado: ' + CONVERT(VARCHAR(10), @VAL_UltId_Valor)
	
		IF(@VAL_UltId_Valor <> 0)
		BEGIN
			SET @VAL_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE Id_Trans = @pId_Trans AND Id_Valor = @VAL_UltId_Valor), 0)
		
			----PRINT 'Generacion de Items por cada Id_Tipo_Val del Periodo de Caja: ' + CONVERT(VARCHAR(10), @VAL_UltId_Periodo_Caja)
			DECLARE curGenCtaCteHaber_Val CURSOR FOR 
				SELECT DISTINCT Id_Tipo_Val 
				FROM Valores 
				WHERE 
				Id_Trans = @pId_Trans
				AND Id_Periodo_Caja = @VAL_UltId_Periodo_Caja
		
			OPEN curGenCtaCteHaber_Val
			FETCH NEXT FROM curGenCtaCteHaber_Val INTO @VAL_Id_Tipo_Val
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont FROM Valores_Tipos WHERE Id_Tipo_Val = @VAL_Id_Tipo_Val), 0)
				SET @Id_Cta_Contable = (SELECT Id_Cta_Contable FROM Pla_Ctas_Cuentas_Contables WHERE Id_Plan_Cta = @Id_Plan_Cta_Corresp AND Alias = @Alias)
				SET @Haber = (SELECT SUM(Importe) FROM Valores WHERE Id_Trans = @pId_Trans AND Id_Tipo_Val = @VAL_Id_Tipo_Val AND Id_Periodo_Caja = @VAL_UltId_Periodo_Caja)
				SET @NroItem = @NroItem + 1
		
				----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				0/*Debe*/,		@Haber,				''/*Observacion*/,
				@Alias,			0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)

				FETCH NEXT FROM curGenCtaCteHaber_Val INTO @VAL_Id_Tipo_Val
			END 
			CLOSE curGenCtaCteHaber_Val;
			DEALLOCATE curGenCtaCteHaber_Val;		
		END
	
		----PRINT 'FIN Compromete Transferencia de Fondos'
	END /*IF(@Flag_Compromete_Trans_Fondos = 1)*/

	IF(@Flag_Compromete_Recibos = 1)
	BEGIN
	    DECLARE @Tomar_Asiento_Cbte SMALLINT 
		SET @Tomar_Asiento_Cbte = (SELECT ISNULL(Valor_Integer,0) FROM xParametros WHERE IdParametro = 'Tomar_Asiento_Cbte') 

	    SET @NroItem = 1	
		----PRINT 'Compromente Recibos'
		
		----PRINT 'Generacion Cuenta Contable: DEBE'

		SET @VAL_UltId_Valor = ISNULL((SELECT MAX(Id_Valor) FROM Valores_Mov WHERE Id_Trans = @pId_Trans), 0)
		----PRINT 'Valores. Ult. Id_Valor Generado: ' + CONVERT(VARCHAR(10), @VAL_UltId_Valor)
	
		IF(@VAL_UltId_Valor <> 0)
		BEGIN
			SET @VAL_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE  Id_Valor = @VAL_UltId_Valor), 0)
		
			----PRINT 'Generacion de Items por cada Id_Tipo_Val del Periodo de Caja: ' + CONVERT(VARCHAR(10), @VAL_UltId_Periodo_Caja)
			DECLARE curGenCtaDEBE_Val CURSOR FOR 
					SELECT DISTINCT V.Id_Tipo_Val,ISNULL(V.ID_TARJETA,''),ISNULL(V.ID_CTA_BANCO,0)
					FROM Valores_MOV M, VALORES V 
					WHERE 
					M.Id_Trans = @pId_Trans
					AND M.ID_VALOR = V.ID_VALOR
					AND M.Id_Periodo_Caja = @VAL_UltId_Periodo_Caja
		
			OPEN curGenCtaDEBE_Val
			FETCH NEXT FROM curGenCtaDEBE_Val INTO @VAL_Id_Tipo_Val,@ID_TARJETA,@ID_CTA_BANCO
			WHILE @@FETCH_STATUS = 0
			BEGIN
			    SET @Alias = 0 
			    IF @VAL_Id_Tipo_Val = 'TAR'
				   BEGIN
				      SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont FROM Valores_Tarjetas_Cred WHERE ID_TARJETA = @ID_TARJETA), 0)
                   END
			    IF @VAL_Id_Tipo_Val = 'DB'
				   BEGIN
				      SET @Alias = ISNULL((SELECT Id_Cta_Contable FROM Bancos_Ctas WHERE Id_Cta_Banco = @ID_CTA_BANCO), 0)
                   END	    
				IF @Alias = 0  
				   BEGIN
				      SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont FROM Valores_Tipos WHERE Id_Tipo_Val = @VAL_Id_Tipo_Val), 0)
                   END


				SET @Id_Cta_Contable = 	  (SELECT dbo.CF_Cta_Cont(@Alias, @Fecha_Cbte))
				SET @NroItem = @NroItem + 1
			    SET @Id_Centro_Costo = ''
			    SET @Debe = (SELECT SUM(V.Importe) FROM Valores V, Valores_Mov M WHERE M.Id_Trans = @pId_Trans AND M.id_valor = V.Id_Valor And V.Id_Tipo_Val = @VAL_Id_Tipo_Val AND M.Id_Periodo_Caja = @VAL_UltId_Periodo_Caja AND ISNULL(V.Id_Tarjeta,'') = @ID_TARJETA AND ISNULL(V.Id_Cta_Banco,0) = @Id_Cta_Banco)
	
				----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				@Debe,		0,				''/*Observacion*/,
				@Alias,		0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)

				FETCH NEXT FROM curGenCtaDEBE_Val INTO @VAL_Id_Tipo_Val,@ID_TARJETA,@ID_CTA_BANCO
			END 
			CLOSE curGenCtaDEBE_Val;
			DEALLOCATE curGenCtaDEBE_Val;		
		END

		/*Insert: Cuenta Contable: HABER*/
		----PRINT 'Generacion Cuenta Contable: HABER'
		----PRINT 'Valores. Ult. Id_Valor Generado: ' + CONVERT(VARCHAR(10), @VAL_UltId_Valor)
		
		IF(@VAL_UltId_Valor <> 0)
		BEGIN
		    IF @Tomar_Asiento_Cbte = 0
			BEGIN
				SET @VAL_UltId_Periodo_Caja = ISNULL((SELECT Id_Periodo_Caja FROM Valores WHERE Id_Valor = @VAL_UltId_Valor), 0)
				
				SET @Alias = ISNULL((SELECT Id_Alias_Cta_Cont_Venta FROM Clientes WHERE Id_Cliente = @Id_Cliente), 0)
				SET @Id_Cta_Contable = (SELECT dbo.CF_Cta_Cont(@Alias, @Fecha_Cbte))
				SET @Haber = (SELECT SUM(V.Importe) FROM Valores V, Valores_Mov M WHERE M.Id_Trans = @pId_Trans AND M.id_valor = V.Id_Valor  AND M.Id_Periodo_Caja = @VAL_UltId_Periodo_Caja )
				SET @NroItem = @NroItem + 1
		
				----PRINT 'Item: ' + CONVERT(VARCHAR(10), @NroItem) + '. Id_Tipo_Val: ' + @VAL_Id_Tipo_Val + '. Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. Id_Cta_Contable: ' + CONVERT(VARCHAR(10), @Id_Cta_Contable)
	
				INSERT INTO Cbtes_Ctas_Contables
				(Id_Trans,		Id_Cta_Contable,	Fecha,
				Debe,			Haber,				Observacion,
				Alias,			Id_Asiento,			Id_Centro_Costo,
				Item)
				VALUES									
				(@pId_Trans,	@Id_Cta_Contable,	@Fecha_Cbte,
				0/*Debe*/,		@Haber,				''/*Observacion*/,
				@Alias,			0/*Id_Asiento*/,	''/*@Id_Centro_Costo*/,
				@NroItem)
		    END
		   ELSE
			BEGIN
			SELECT * INTO #CTAS_AUX FROM CBTES_CTAS_CONTABLES WHERE ID_TRANS = 1
			DELETE #CTAS_AUX

			DECLARE curGenCtaDEBE_FAC_APLIC2 CURSOR FOR 


			SELECT ID_TRANS
				FROM CBTES_APLICA WHERE ID_TRANS_D = @pId_Trans

		
				OPEN curGenCtaDEBE_FAC_APLIC2
				FETCH NEXT FROM curGenCtaDEBE_FAC_APLIC2 INTO @ID_TRANS_ORIGEN
				WHILE @@FETCH_STATUS = 0
				BEGIN
				    INSERT INTO #CTAS_AUX
					    SELECT * FROM CBTES_CTAS_CONTABLES WHERE ID_TRANS = @ID_TRANS_ORIGEN AND DEBE <> 0

				    FETCH NEXT FROM curGenCtaDEBE_FAC_APLIC2 INTO  @ID_TRANS_ORIGEN
		    	END 

				ALTER TABLE #CTAS_AUX ADD _Item INT IDENTITY(20,1)
		      	UPDATE #CTAS_AUX SET ID_TRANS = @pId_Trans,  Id_Cta_Contable = (SELECT dbo.CF_Cta_Cont(Alias, @Fecha_Cbte))
				UPDATE #CTAS_AUX SET Item = _Item, Id_Asiento = 0, Fecha = @Fecha_Cbte, HABER = DEBE
				UPDATE #CTAS_AUX SET DEBE = 0
				ALTER TABLE #CTAS_AUX DROP COLUMN _Item

				INSERT INTO CBTES_CTAS_CONTABLES 
				       SELECT * FROM #CTAS_AUX
                DROP TABLE #CTAS_AUX

			    CLOSE curGenCtaDEBE_FAC_APLIC2
			    DEALLOCATE curGenCtaDEBE_FAC_APLIC2		 
	    	END
		
		END ----PRINT 'FIN Compromente Recibos'
	END	

	COMMIT

	SET @Mensaje = 'Asiento Generado'

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,@pId_Trans				AS ErrorLine		
			,@Mensaje		AS ErrorMessage
			--,@pId_Trans		AS Id_Trans

END TRY  


BEGIN CATCH  
  --  SELECT  ERROR_NUMBER() AS ErrorNumber  
		--,ERROR_SEVERITY() AS ErrorSeverity  
		--,ERROR_STATE() AS ErrorState  
		--,ERROR_PROCEDURE() AS ErrorProcedure  
		--,ERROR_LINE() AS ErrorLine  
		--,ERROR_MESSAGE() AS ErrorMessage
		--,@pId_Trans		AS Id_Trans 
    EXECUTE usp_GetErrorInfo
	ROLLBACK

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_FAC_APLIC2') ) = -1
	   DEALLOCATE curGenCtaDEBE_FAC_APLIC2		 

	IF (SELECT CURSOR_STATUS('global','curGenCtaDEBE_FAC_APLIC2') ) = 1
	BEGIN
	   CLOSE curGenCtaDEBE_FAC_APLIC2
	   DEALLOCATE curGenCtaDEBE_FAC_APLIC2		 
	END



	RETURN 9999

END CATCH

--PRINT 'Fin de ejecucion: CP_Cbtes_Ctas_Contables_Generar  Trans: '+ CAST(@pId_Trans AS VARCHAR(10))

RETURN 0



-- EXEC CP_Cbtes_Ctas_Contables_Generar 298281,1

-- EXEC CP_Cbtes_Ctas_Contables_Generar 1232043,1


